using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.AHOBPR.BO;
using VIRP.AHOBPR.DAL;

namespace VIRP.AHOBPR.BLL
{
	public static partial class STD_FORMManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static STD_FORM GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_ID)
		{
			STD_FORM objReturn = null;
			STD_FORMDB objDB = new STD_FORMDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_ID);

			return objReturn;
		}

        public static STD_FORM GetItemByToolFormId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 TOOL_FORM_ID)
        {
            STD_FORM objReturn = null;
            STD_FORMDB objDB = new STD_FORMDB();

            objReturn = objDB.GetItemByToolFormId(CURRENT_USER, CURRENT_REGISTRY_ID, TOOL_FORM_ID);

            return objReturn;
        }

        public static STD_FORM GetFormByToolFormId(string TOOL_FORM_ID)
        {
            STD_FORM objReturn = null;
            int temp = 0;
            if (int.TryParse(TOOL_FORM_ID, out temp))
                objReturn = GetItemByToolFormId(string.Empty, 0, temp);
            return objReturn;
        }

        public static STD_FORM GetItemByBprFormId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string BPR_FORM_ID)
        {
            STD_FORM objReturn = null;
            STD_FORMDB objDB = new STD_FORMDB();

            objReturn = objDB.GetItemByBprFormId(CURRENT_USER, CURRENT_REGISTRY_ID, BPR_FORM_ID);

            return objReturn;
        }

        public static int GetFollowupFormId(string BPR_FORM_ID)
        {
            STD_FORM objTemp = GetItemByBprFormId(string.Empty, 0, BPR_FORM_ID);
            if (objTemp != null)
                return objTemp.STD_FORM_ID;

            return 0;
        }

        public static List<STD_FORM> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<STD_FORM> objReturn = null;
			STD_FORMDB objDB = new STD_FORMDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_FORM objSave)
		{
			Int32 objReturn = 0;
			STD_FORMDB objDB = new STD_FORMDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_ID)
		{
			Boolean objReturn = false;
			STD_FORMDB objDB = new STD_FORMDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_FORM objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.STD_FORM_ID);
		}

        public static bool IsFormSystemWide(int formId)
        {
            bool isSystemWide = false;

            List<STD_FORM> forms = GetItems(string.Empty, 0);
            List<TOOL_FORM> tools = TOOL_FORMManager.GetItems(string.Empty, 0);

            if (forms != null && tools != null)
            {
                int? toolFormId = (from e in forms
                                   where e.STD_FORM_ID == formId
                                   select e.TOOL_FORM_ID).FirstOrDefault();

                isSystemWide = (from e in tools
                                where e.SYSTEM_WIDE_FLAG == true
                                   && e.TOOL_FORM_ID == toolFormId
                                select e).ToList().Count > 0;
            }
            return isSystemWide;
        }

        public static int GetFormAnswerId(int sqlQuestionId, string bprAnswerId)
        {
            int id = 0;
            if (sqlQuestionId == 0 || string.IsNullOrEmpty(bprAnswerId))
            {
                return id;
            }
            else
            {
                if (AHOBPRGlobal.FormAnswerLookup == null)
                {
                    AHOBPRGlobal.FormAnswerLookup = STD_FORM_ANSWERManager.GetItems(string.Empty, 0);
                }

                try
                {
                    id = (from e in AHOBPRGlobal.FormAnswerLookup
                          where e.STD_FORM_QUESTION_ID == sqlQuestionId && e.BRP_FORM_ANSWER_ID == bprAnswerId
                          select e.STD_FORM_ANSWER_ID).FirstOrDefault();
                }
                catch
                {
                    id = 0;
                }

                return id;
            }
        }

        public static int GetDeploymentId(int registrantId, string bprDeploymentId)
        {
            int id = 0;
            if (string.IsNullOrEmpty(bprDeploymentId))
            {
                return id;
            }
            else
            {
                List<REGISTRANT_DEPLOYMENT> deployments = REGISTRANT_DEPLOYMENTManager.GetItems(string.Empty, 0);
                if (deployments != null)
                {
                    id = (from e in deployments
                          where e.REGISTRANT_ID == registrantId && e.BPR_DEPLOYMENT_ID == bprDeploymentId
                          select e.REGISTRANT_DEPLOYMENT_ID).FirstOrDefault();
                }
            }
            return id;
        }

        public static int GetFormQuestionIdForFollowupQuestion(int formId, string bprQuestionId)
        {
            int id = 0;
            if (formId == 0 || string.IsNullOrEmpty(bprQuestionId))
            {
                return id;
            }
            else
            {
                if (AHOBPRGlobal.FormQuestionLookup == null)
                {
                    AHOBPRGlobal.FormQuestionLookup = STD_FORM_QUESTIONManager.GetItems(string.Empty, 0);
                }

                try
                {
                    id = (from e in AHOBPRGlobal.FormQuestionLookup
                          where e.STD_FORM_ID == formId && e.FORM_QUESTION_UNIQUE_ID == bprQuestionId
                          select e.STD_FORM_QUESTION_ID).FirstOrDefault();
                }
                catch
                {
                    id = 0;
                }

                return id;
            }
        }

        #endregion
    }
}
